#ifdef _DEBUG
/***************************************************************/
//
//
//		DirectX	[ debug.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 10/28
/*---------------------------------------------------------------
Update : 2016/10/28
			debug.cpp̍쐬
			fobKpC^[tF[X

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "debug.h"

#include "emitter.h"
#include "controller.h"

#include "resource.h"
#include "tool_proc.h"

#include "mouse.h"
#include "particle.h"

//#include "mouse.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define TEXTURE_NAME "data/TEXTURE/fade000.png"			// eNX`pX

#define NUM_VERTEX  ( 4 )								// 1`Ŏgp钸_
#define NUM_POLYGON ( 2 )								// `悷|S

#define START_COORD_X (0)								// \WSX
#define START_COORD_Y (0)								// \ʒuSY
#define END_COORD_X   (10)								// \WEX
#define END_COORD_Y   (10)								// \WEX

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
void RenderDebugInfo( void );
HRESULT MakeVertexDebug( LPDIRECT3DDEVICE9 pDevice );	// _̍쐬
void SetVertexDebugCoord( VERTEX_2D* pVtx );			// _W̐ݒ
void SetVertexDebugSpriteUV( VERTEX_2D* pVtx );			// _UVl̐ݒ
void SetVertexDebugColor( VERTEX_2D* pVtx );			// _F̐ݒ

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureDebug = nullptr;			// eNX`-C^[tF-X
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferDebug = nullptr;	// _obt@C^[tF[Xւ̃|C^

LPD3DXFONT g_pFontEx = nullptr;							// FPSEBhEɏނ߂̃C^[tF[X

//extern char TEXTURE_NAME_ALPHA[ 256 ][ 256 ];



// fobO񏑂
void RenderDebugInfo( void )
{

	// FPS̕`O
	RECT rect={ 0,0,SCREEN_WIDTH,SCREEN_HEIGHT };

	char str[ 8192 ];
	EMITTER* emitter = GetEmitter( );
	int index = GetEmitterIndex();

	// fobO񏑂
	sprintf( str,
		"\n [ %s ] \n\
		 ALL PROCESS FPS : %d \n\
		 ------------------------ \n\
		 EMITTER NUMBER : %d / %d \n\
		 EDIT EMITTER : [ %d ] \n\
		 ------------------------ \n\
		 MOUSE X:%d Y:%d Z:%d \n\
		 ------------------------ \n\
		 \n\
		 EMIITER [ EDIT : %d ] < > \n\
		 operation :[ <,> ] ChangeIndex \n\
		 \n\
		 center   : x;%f y:%f z:%f \n\
		 speed	   : x;%f y:%f z:%f \n\
		 velocity : x;%f y:%f z:%f \n\
		 color	   : r;%f g:%f b:%f a:%f \n\
		 radius	  : r = %f \n\
		 theta	   : %d \n\
		  ->offset: %d \n\
		 phy      : %d \n\
		  ->offset: %d \n\
		 life     : %d \n\
		 textureIndex : %d \n\
		 \n\
		 gravity  : x;%f y:%f z:%f \n\
		 amibent  : x;%f y:%f z:%f \n\
		 rotation : x;%f y:%f z:%f \n\
		 ",
		WINDOW_NAME,
		GetFps(),
		GetEmitterNumber(),EMITTER::EMITTER_MAX,
		GetEmitterIndex(),
		GetMouseX(), GetMouseY(), GetMouseZ(),
		GetEmitterIndex(),
		emitter[ index ].center.x, emitter[ index ].center.y, emitter[ index ].center.z,
		emitter[ index ].speed.x, emitter[ index ].speed.y, emitter[ index ].speed.z,
		emitter[ index ].velocity.x, emitter[ index ].velocity.y, emitter[ index ].velocity.z,
		emitter[ index ].color.r, emitter[ index ].color.g, emitter[ index ].color.b, emitter[ index ].color.a,
		emitter[ index ].radius, 
		emitter[ index ].theta, 
		emitter[ index ].theta_offset,
		emitter[ index ].phy,
		emitter[ index ].phy_offset,
		emitter[ index ].life, 
		emitter[ index ].textureIndex,
		PARTICLE::GRAVITY.x, PARTICLE::GRAVITY.y, PARTICLE::GRAVITY.z,
		PARTICLE::AMBIENT.x, PARTICLE::AMBIENT.y, PARTICLE::AMBIENT.z,
		PARTICLE::ROTATION.x, PARTICLE::ROTATION.y, PARTICLE::ROTATION.z
		);	


	// FPS̕`揈
	g_pFontEx->DrawText(NULL,&str[0],-1,&rect,DT_LEFT,D3DCOLOR_RGBA(100,255,255,255));

	// fobO񏑂
	char** buf = GetTextureParticle( ); 
	char texString[ 8192 ] = {" \n\n\n LOAD TEXTURE  >>>>>>>>>>\n\
							      ------------------------ " };
	for( int index = 0; index < PARTICLE::LOAD_TEXTURE; index++ ){
	//for( int index = 0; index < 13; index++ ){
		sprintf( texString, "%s\nindex[%d] : %s", texString, index, buf[ index ] );
		//sprintf( texString, "%s\nindex[%d] : %s", texString, index, TEXTURE_NAME_ALPHA[index] );
	}
	g_pFontEx->DrawText(NULL,&texString[0],-1,&rect,DT_RIGHT,D3DCOLOR_RGBA(100,255,255,255));
	
}

// DEBUG̏
void InitDebug( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexDebug( pDevice );

	// eNX`̓ǂݍ 
	if( FAILED( D3DXCreateTextureFromFile( pDevice, TEXTURE_NAME, &g_pTextureDebug )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "DEBUGeNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}

	// fobOtHg̍쐬
	D3DXCreateFont( pDevice,18,0,0,0,FALSE,
	SHIFTJIS_CHARSET,
	OUT_DEFAULT_PRECIS,
	DEFAULT_QUALITY,
	DEFAULT_PITCH,
	"terminal",&g_pFontEx );


}

// DEBUG̏I
void UninitDebug( void )
{

	// eNX`C^[tF[X̊J
	SAFE_RELEASE( g_pTextureDebug )

	// _obt@C^[tF[X̊J
	SAFE_RELEASE( g_pVtxBufferDebug )

	// tHg\p̃C^[tF[X̊J
	SAFE_RELEASE(g_pFontEx)

}

// DEBUG̍XV
void UpdateDebug( void )
{

	VERTEX_2D *pVtx;										// zAhX


	// obt@bNzAhX擾
	g_pVtxBufferDebug -> Lock( 0, 0, (void**)&pVtx, 0 );

	
	{// _obt@̐ݒ


		// _W̐ݒ
		//SetVertexDebugCoord( pVtx );

		// _UVl̐ݒ
		//SetVertexDebugSpriteUV( pVtx );

		// _F̐ݒ
		//SetVertexDebugColor( pVtx );

		// rhw̐ݒ
		//pVtx[0].rhw = 1.0f;
		//pVtx[1].rhw = 1.0f;
		//pVtx[2].rhw = 1.0f;
		//pVtx[3].rhw = 1.0f;


	}// SetVertex -> END 
	

	g_pVtxBufferDebug ->Unlock( );


}

// DEBUG̕`
void DrawDebug( void )
{

	/*
	// foCX̎󂯎菈
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );


	// Xg[
	pDevice ->SetStreamSource( 0,
	g_pVtxBufferDebug,								// Xg[ɃoCh钸_obt@
	0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
	sizeof( VERTEX_2D ));							// ̃XgChl(oCgP)


	// _tH[}bg̐ݒ
	pDevice ->SetFVF( FVF_VERTEX_2D );


	// eNX`̐ݒ
	pDevice ->SetTexture( 0, g_pTextureDebug );


	// |S̕`
	pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON );*/

	// fobȌ
	RenderDebugInfo( );

}

// _̍쐬
HRESULT MakeVertexDebug( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_2D *pVtx;									// zAhX


	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
			sizeof( VERTEX_2D ) * NUM_VERTEX,			// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							// gp@
			FVF_VERTEX_2D,								// gp钸_tH[}bg
			D3DPOOL_MANAGED,							// obt@̊Ǘ@
			&g_pVtxBufferDebug,							// i[|C^
			NULL )))
	{

		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " DEBUG VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG

		return E_FAIL;

	}


	// zAhX̎擾
	g_pVtxBufferDebug -> Lock( 0, 0, (void**)&pVtx, 0 );


	{// _obt@̐ݒ

		// _W̐ݒ
		SetVertexDebugCoord( pVtx );

		// _UVl̐ݒ
		SetVertexDebugSpriteUV( pVtx );

		// _F̐ݒ
		SetVertexDebugColor( pVtx );

		// rhw̐ݒ
		pVtx[0].rhw = 1.0f;
		pVtx[1].rhw = 1.0f;
		pVtx[2].rhw = 1.0f;
		pVtx[3].rhw = 1.0f;

	}// SetVertex -> END 


	// obt@̃AbN
	g_pVtxBufferDebug ->Unlock( );

	return S_OK;


}

// _W̐ݒ
void SetVertexDebugCoord( VERTEX_2D* pVtx )
{


	D3DXVECTOR2 start,end;				// n_ƏI_
	D3DXVECTOR2 center;					// SW
	D3DXVECTOR2 radius;					// XvCga
	D3DXVECTOR2 coord[ NUM_VERTEX ];	// W̌vZli[p
	const  float ANGLE_VARIATION = 0;	// 1t[ł̊pxω
	static float arc;					// ]px
	static float scale = 1.0f;			// gkl



	{ // Wl

		// a̐ݒ
		radius.x = (( END_COORD_X - START_COORD_X ) * 0.5f ); 
		radius.y = (( END_COORD_Y - START_COORD_Y ) * 0.5f ); 

		// SW̐ݒ
		center.x = START_COORD_X + radius.x;
		center.y = START_COORD_Y + radius.y;

	} // -> ݒI



	// XvCggk
	scale += 0.0f;

	{ // XP[

		radius *= scale;

	}

	// XvCg]
	arc -= ANGLE_VARIATION;

	{ // AtBϊ


		coord[ 0 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, -radius.y, arc );
		coord[ 0 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, -radius.y, arc );

		coord[ 1 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, -radius.y, arc );
		coord[ 1 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, -radius.y, arc );

		coord[ 2 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, radius.y, arc );
		coord[ 2 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, radius.y, arc );

		coord[ 3 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, radius.y, arc );
		coord[ 3 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, radius.y, arc );


	} // -> ϊI


	// W̏
	for( int index = 0; index < NUM_VERTEX; index++ )
	{
		pVtx[ index ].pos=D3DXVECTOR3( coord[ index ].x, coord[ index ].y  , 0.0f );
	}
	


	/*
	// W̐ݒ
	start.x = START_COORD_X;
	start.y = START_COORD_Y;
	end.x   = END_COORD_X;
	end.y   = END_COORD_Y;


	// W̏
	pVtx[0].pos=D3DXVECTOR3( start.x, start.y, 0.0f );
	pVtx[1].pos=D3DXVECTOR3( end.x  , start.y, 0.0f );
	pVtx[2].pos=D3DXVECTOR3( start.x, end.y  , 0.0f );
	pVtx[3].pos=D3DXVECTOR3( end.x  , end.y  , 0.0f );
	*/

}

// _UVl̐ݒ
void SetVertexDebugSpriteUV( VERTEX_2D* pVtx )
{


	const unsigned int TEXTURE_SHEETS_U = 1;		// eNX`Aj[V
	const unsigned int TEXTURE_SHEETS_V = 1;		// eNX`cAj[V
	const unsigned int FPS = 1 ;					// t[p[ZJh(҂)
	const float TEXTURE_U = 1.0f / TEXTURE_SHEETS_U;// eNX` U l萔
	const float TEXTURE_V = 1.0f / TEXTURE_SHEETS_V;// eNX` V l萔
	float TexU = 0,TexV = 0;						// eNX`UVľvZɎgp
	static unsigned int animationFrame;				// Aj[Vt[



	// UVľvZ
	TexU = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_U ) * TEXTURE_U;
	TexV = ( float )( (( animationFrame/TEXTURE_SHEETS_U ) / FPS ) % TEXTURE_SHEETS_V ) * TEXTURE_V;


	// _UVl̏
	pVtx[0].tex = D3DXVECTOR2( TexU            , TexV );
	pVtx[1].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV );
	pVtx[2].tex = D3DXVECTOR2( TexU            , TexV + TEXTURE_V );
	pVtx[3].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV + TEXTURE_V );


	// Aj[Vt[̍XV
	animationFrame ++;


}

// _F̐ݒ
void SetVertexDebugColor( VERTEX_2D* pVtx )
{

	static D3DXCOLOR vertexColor = D3DXCOLOR( 0.75f, 0.75f, 0.75f, 1.0f );	// _F

	const float MAX_COLOR = 1.0f;										// F̍ől
	const float MIM_COLOR = 0.6f;										// F̍ŏl
	const float TRANSLATE_COLOR = 0.005f;								// t[̐F̍XVl
	static float transitionColor = 0.0f;								// FύXl
	static bool frag = true;											// ܂ԂtO


	// F̑J
	if( transitionColor >= MAX_COLOR ){

		frag = false;

	}

	if( frag ){

		transitionColor += TRANSLATE_COLOR;
	}
	else{

		transitionColor -= TRANSLATE_COLOR;

		if( transitionColor <= MIM_COLOR ){

			frag = true;
		}

	}



	{ // _F̍XV


		//vertexColor.r = transitionColor; 
		//vertexColor.g = transitionColor; 
		//vertexColor.b = transitionColor; 
		//vertexColor.a = transitionColor; 

	}



	// _F̏
	pVtx[0].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[1].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[2].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[3].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );



}


#endif	// _DEBUG


